<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'license' => 'MIT License

Copyright (c) 2025 sait-modx.by

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
',
    'readme' => 'scxcaptchaAjaxForm
==================

Неблокирующая числовая CAPTCHA (5 цифр) для AjaxForm/FormIt и FetchIt. Простая для человека, сложнее для ботов. Все имена/классы с префиксом scx_.

Новое в 1.0.1
-------------
- Поддержка FetchIt: фронтовый адаптер слушает события fetchit:success / fetchit:error / fetchit:reset и автоматически
  перерисовывает капчу и очищает поле scx_code.
- Показ ошибок для FetchIt: если сервер вернул текст ошибки по scx_code, он отображается под полем ввода.
- Улучшен UX: после успешной отправки капча перерисовывается без «Bad token» (см. примечание по хуку ниже).
- Документация обновлена, добавлены примеры для FetchIt.

Требования
----------
- MODX Revolution 2.8+ или 3.x
- PHP 7.4+ (рекомендуется 8.x)
- GD + TrueType (для TTF-шрифта)

Установка
---------
1) Установите пакет через Менеджер пакетов.
2) Убедитесь, что шрифт assets/components/scxcaptchaajaxform/fonts/DejaVuSansMono.ttf существует (если нет — будет использован bitmap-фолбэк).

Быстрый старт
-------------
Вставьте блок капчи в форму (ВАЖНО: некэшируемо):
[[!ScxCaptchaAjaxForm]]

Пример с AjaxForm:
[[!AjaxForm?
  &snippet=`FormIt`
  &form=`tpl.AjaxForm.example`
  &hooks=`ScxCaptchaAjaxFormHook,email`
  &validate=`name:required,email:required:email,scx_code:required`
]]

Пример с чистым FormIt:
[[!FormIt?
  &hooks=`ScxCaptchaAjaxFormHook,email`
  &validate=`name:required,email:required:email,scx_code:required`
]]
[[!ScxCaptchaAjaxForm]]

Параметры сниппета
------------------
ttl — время жизни токена, сек. По умолчанию 1200 (20 минут).
Пример: [[!ScxCaptchaAjaxForm? &ttl=`900`]]

includeAssets — как подключать CSS/JS:
- head (по умолчанию) — добавить в <head> через regClient* (для обычных страниц)
- inline — вернуть CSS/JS вместе с HTML блока (для AJAX-модалок/фрагментов)
- none — не подключать (если scx.css/scx.js уже подключены глобально)

render — возвращать ли сам HTML блока:
- 1 (по умолчанию) — вернуть HTML капчи
- 0 — отдать только ассеты (удобно вызвать один раз на странице)

Поведение при первой загрузке
-----------------------------
Сессия не закрывается (совместимо с AjaxForm/FetchIt). При первом показе рендерится «заглушка» (прозрачный 1×1 GIF). Реальная картинка капчи подгружается:
- по клику «Обновить»,
- по клику на изображение,
- при фокусе поля scx_code.

Поля формы
----------
scx_hp — honeypot (должно оставаться пустым)
scx_ts — timestamp рендера формы (мс) для анти-бот проверки (>= 3 сек)
scx_code — ответ пользователя (ровно 5 цифр)
scx_token — скрытый токен текущей капчи

Как это работает
----------------
1) Сниппет создаёт токен и кладёт его в $_SESSION[\'scx_allowed\'] (TTL настраивается параметром ttl).
2) JS подставляет src картинки по действию пользователя.
3) assets/components/scxcaptchaajaxform/captcha.php генерирует код (5 цифр), сохраняет его хэш в $_SESSION[\'scx_code\'][TOKEN] и отдаёт PNG.
4) Хук ScxCaptchaAjaxFormHook валидирует (honeypot, время, токен, код) и очищает данные (одноразово).

Примечание к хуку (во избежание «Bad token»)
--------------------------------------------
В конце успешной проверки удаляйте ТОЛЬКО $_SESSION[\'scx_code\'][$token].
Не удаляйте $_SESSION[\'scx_allowed\'][$token] — так фронт сможет безопасно перерисовать картинку с тем же токеном.
Токены автоматически чистятся по TTL на стороне сниппета.

Интеграция с FetchIt
--------------------
scxcaptchaAjaxForm полностью совместим с FetchIt. Серверная часть не меняется (обычно форма уходит в FormIt, где стоит хук ScxCaptchaAjaxFormHook).

Фронтовый адаптер пакета обрабатывает события FetchIt и автоматически:
- fetchit:success — очищает ошибку у scx_code, перерисовывает капчу;
- fetchit:error — если сервер вернул ошибку scx_code (errors.scx_code или data.scx_code), показывает её под полем и перерисовывает капчу;
- fetchit:reset — очищает ошибку и перерисовывает капчу.

Это работает из коробки, если ассеты пакета подключены (includeAssets=head или includeAssets=inline) либо scx.css/scx.js подключены глобально.

Примеры разметки для FetchIt

1) Статичная форма, которую FetchIt перехватывает по атрибуту:
<form class="form" method="post" action="[[~[[*id]]]]" data-fetchit>
  <!-- ваши поля -->
  [[!ScxCaptchaAjaxForm]]
  <button type="submit">Отправить</button>
</form>

2) Форма, вставляемая в модалку (фрагментом):
[[!ScxCaptchaAjaxForm? &includeAssets=`inline`]]
<button type="submit">Отправить</button>

Инлайн-ассеты гарантируют, что JS/CSS капчи подхватятся даже при AJAX-вставке.

Фронтовое API
-------------
Принудительно перерисовать капчу внутри конкретной формы:
window.ScxCaptcha.reloadInForm(formElement);

Настройки ассетов (сводка)
--------------------------
[[!ScxCaptchaAjaxForm]] — обычная страница (ассеты в head, вернуть блок).
[[!ScxCaptchaAjaxForm? &includeAssets=`inline`]] — модалка/фрагмент через AJAX.
[[!ScxCaptchaAjaxForm? &render=`0`]] — подключить ассеты один раз (без разметки).
[[!ScxCaptchaAjaxForm? &includeAssets=`none`]] — вернуть только разметку (если scx.css/js уже подключены глобально).

Отладка
-------
Добавьте &debug=1 к URL картинки (captcha.php?...&debug=1) — получите:
session_name, cookie, requested token, allowed tokens.

Если видите Bad token, проверьте:
- вызов капчи некэшируемо: [[!ScxCaptchaAjaxForm]];
- страница и /assets/components/scxcaptchaajaxform/captcha.php обслуживаются одним доменом/поддоменом;
- для модалок используйте includeAssets=inline или подключите scx.css/js глобально;
- для FormIt: в вызове есть &hooks=ScxCaptchaAjaxFormHook и в &validate присутствует scx_code:required;
- для FetchIt: форма реально инициализирована (есть атрибут data-fetchit и события срабатывают).

Глобальное подключение ассетов (опция)
--------------------------------------
Можно подключить раз и навсегда:
<link rel="stylesheet" href="[[++assets_url]]components/scxcaptchaajaxform/scx.css">
<script src="[[++assets_url]]components/scxcaptchaajaxform/scx.js"></script>

Кастомизация внешнего вида
--------------------------
Переопределяйте CSS-классы на проекте:
.scx-captcha, .scx-img, .scx-refresh, .scx-input, .scx-hp, .scx-error

Безопасность
------------
- Код хранится только как хэш (password_hash).
- Токены короткоживущие и чистятся.
- Ответ валидируется на строго 5 цифр.

Автор и поддержка
-----------------
Разработчик: sait-modx.by
Сайт: https://sait-modx.by
Email: info@sait-modx.by

Если нашли баг или есть идея — напишите нам. Поможем с установкой/интеграцией и кастомизацией под ваш проект.

Лицензия
--------
MIT — см. LICENSE.
',
    'changelog' => 'scxcaptchaAjaxForm — История изменений

v1.0.1 (2025-11-16)
- Совместимость с FetchIt: добавлен фронтовый адаптер, который слушает события fetchit:success / fetchit:error / fetchit:reset
  и автоматически перерисовывает капчу. Ошибки по scx_code отображаются под полем ввода.
- Добавлен публичный фронтовый метод window.ScxCaptcha.reloadInForm(formElement).
- Улучшен UX: после успешной отправки капча перерисовывается без Bad token.
- Документация обновлена (README): раздел «Интеграция с FetchIt», примеры и подсказки по includeAssets/render.

v1.0.0 (начальный релиз)
- Числовая CAPTCHA (ровно 5 цифр) с TTF-шрифтом и лёгким шумом.
- Полная совместимость с AjaxForm и FormIt.
- Без закрытия сессии: первая загрузка показывает «заглушку», реальная картинка подгружается по действию пользователя (кнопка «Обновить», клик по изображению, фокус поля).
- Универсальные имена с префиксом scx_:
  * Поля формы: scx_hp, scx_ts, scx_code, scx_token
  * Ключи сессии: $_SESSION[\'scx_allowed\'], $_SESSION[\'scx_code\']
  * CSS-классы: .scx-captcha, .scx-img, .scx-refresh, .scx-input, .scx-hp
- Параметры сниппета:
  * includeAssets=head|inline|none — способ подключения CSS/JS (head по умолчанию)
  * render=1|0 — отдавать ли HTML блока (1 по умолчанию)
  * ttl — время жизни токена (по умолчанию 1200 сек)
- Поддержка нескольких форм на странице; инициализация динамически добавленных форм (MutationObserver).
- Автоочистка просроченных токенов в сессии.
- Хранение ответа в сессии только как хэш (password_hash); одноразовая валидация.
- Режим отладки для captcha.php: ?debug=1 (session_name, cookie, token, allowed tokens).
- Готовые ассеты scx.css/scx.js (возможность подключать глобально).
- Документация: инструкция по установке/использованию, примеры для AjaxForm и FormIt.
',
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modNamespace',
      'guid' => 'e8c3e1ef8609819b37c6187c8eb75a1d',
      'native_key' => 'scxcaptchaajaxform',
      'filename' => 'modNamespace/d8122d55188d5cdeee2143979c2d39ec.vehicle',
      'namespace' => 'scxcaptchaajaxform',
    ),
    1 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modCategory',
      'guid' => '51aae0e0bc7c51bc6ace62eb6416106d',
      'native_key' => 1,
      'filename' => 'modCategory/cfb2c154dcae74de5ad1bf2489a934b5.vehicle',
      'namespace' => 'scxcaptchaajaxform',
    ),
  ),
);