<?php
// === DEBUG: &debug=1 выдаст текст вместо PNG ===
$__DEBUG = isset($_GET['debug']) && $_GET['debug'] == '1';
if ($__DEBUG) { ini_set('display_errors',1); error_reporting(E_ALL); header('Content-Type: text/plain; charset=UTF-8'); }

/* ищем MODX config.core.php вверх по дереву */
function sc_find_modx_config($dir){
  for($i=0;$i<6;$i++){ $p=$dir.'/config.core.php'; if(is_readable($p)) return $p; $dir=dirname($dir); }
  return null;
}
$cfg = sc_find_modx_config(__DIR__); if(!$cfg){ if($__DEBUG) echo "config.core.php not found\n"; http_response_code(500); exit; }
require_once $cfg;

if (!defined('MODX_API_MODE')) define('MODX_API_MODE', true);
require_once MODX_CORE_PATH.'config/'.MODX_CONFIG_KEY.'.inc.php';
require_once MODX_CORE_PATH.'model/modx/modx.class.php';

$modx = new modX();
$modx->initialize('web');
$modx->getService('session','modSessionHandler','', array('cookie_name'=>$site_sessionname??null));
$modx->startSession();

$token = isset($_GET['t']) ? preg_replace('~[^a-f0-9]~i','',$_GET['t']) : '';

if ($__DEBUG) {
  echo "session_name: ", session_name(), "\n";
  echo "cookie[", session_name(), "]: ", $_COOKIE[session_name()] ?? '(no cookie)', "\n";
  echo "requested token: ", $token, "\n";
  $keys = array_keys($_SESSION['scx_allowed'] ?? []);
  echo "allowed tokens: ", ($keys ? implode(',', $keys) : '(empty)'), "\n";
  if(!$token || empty($_SESSION['scx_allowed'][$token])) { echo "Bad token\n"; exit; }
}

/* проверка токена */
if(!$token || empty($_SESSION['scx_allowed'][$token])) {
  http_response_code(400); exit('Bad token');
}

/* ---------- код (ровно 5 цифр) ---------- */
$w = 140; $h = 48;
$code = str_pad((string)random_int(0, 99999), 5, '0', STR_PAD_LEFT);
$_SESSION['scx_code'][$token] = password_hash($code, PASSWORD_DEFAULT);

/* ---------- рисуем PNG ---------- */
$im = imagecreatetruecolor($w,$h);
$bg = imagecolorallocate($im, random_int(230,245), random_int(240,250), 255);
imagefilledrectangle($im,0,0,$w,$h,$bg);

/* лёгкий шум */
for($i=0;$i<70;$i++){
  $c = imagecolorallocatealpha($im, random_int(150,220),random_int(170,230),255, 80);
  imagesetpixel($im, random_int(0,$w-1), random_int(0,$h-1), $c);
}
imagesetthickness($im, 2);
for ($i=0;$i<1;$i++){
  $c = imagecolorallocatealpha($im, random_int(120,180),random_int(150,200),255, 70);
  imageline($im, random_int(0,$w),random_int(0,$h), random_int(0,$w),random_int(0,$h), $c);
}

/* шрифт */
$txtColor = imagecolorallocate($im, 25, 60, 110);
$font = __DIR__.'/fonts/DejaVuSansMono.ttf';
$ttf = is_readable($font) ? $font : null;

/* отрисовка (посимвольно) */
if ($ttf) {
  $size = 24; $x = 12; $y0 = (int)($h * 0.68);
  for ($i=0,$n=strlen($code); $i<$n; $i++) {
    $angle = random_int(-8, 8);
    $y = $y0 + random_int(-2, 2);
    imagettftext($im, $size, $angle, $x, $y, $txtColor, $ttf, $code[$i]);
    $x += 22 + random_int(-1, 1);
  }
} else {
  $fw = imagefontwidth(5) * strlen($code);
  $fh = imagefontheight(5);
  imagestring($im, 5, (int)(($w - $fw)/2), (int)(($h - $fh)/2), $code, $txtColor);
}

header('Content-Type: image/png');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
imagepng($im);
imagedestroy($im);
