<?php
/** @var modX $modx */
/** @var fiHooks $hook */

// Сессия MODX (БД-handler)
if (session_status() !== PHP_SESSION_ACTIVE) {
    $modx->getService('session','modSessionHandler');
    $modx->startSession();
}

$data = $hook->getValues();

/* 1) honeypot */
if (!empty($data['scx_hp'])) {
  $hook->addError('scx_hp', 'Ошибка проверки.');
  return false;
}

/* 2) тайм-чек: минимум 3 сек */
$tsMs = isset($data['scx_ts']) ? (int)$data['scx_ts'] : 0;
if ($tsMs <= 0 || (time() - (int)round($tsMs/1000)) < 3) {
  $hook->addError('scx_code', 'Похоже на автоматическую отправку. Попробуйте ещё раз.');
  return false;
}

/* 3) капча */
$token  = isset($data['scx_token']) ? preg_replace('~[^a-f0-9]~i','', $data['scx_token']) : '';
$answer = isset($data['scx_code'])  ? trim($data['scx_code']) : '';

$allowed = $token && !empty($_SESSION['scx_allowed'][$token]);
$hash    = ($token && !empty($_SESSION['scx_code'][$token])) ? $_SESSION['scx_code'][$token] : '';

$formatOk = ($answer !== '' && ctype_digit($answer) && strlen($answer) === 5);

if (!$allowed || !$hash || !$formatOk || !password_verify($answer, $hash)) {
  $hook->addError('scx_code', 'Неверное число с картинки.');
  return false;
}

/* одноразовая — чистим */
unset($_SESSION['scx_code'][$token]);
// ВАЖНО: НЕ удаляем $_SESSION['scx_allowed'][$token],

return true;
