<?php
/**
 * ScxCaptchaAjaxForm — капча для AjaxForm/FormIt
 * Параметры:
 *   &includeAssets=`head|inline|none`  (по умолчанию head)
 *   &render=`1|0`                      (по умолчанию 1)
 *   &ttl=`1200`                        (время жизни токена, сек)
 */

@session_start();

$includeAssets = isset($includeAssets) ? strtolower(trim($includeAssets)) : 'head';
if (!in_array($includeAssets, ['head','inline','none'], true)) { $includeAssets = 'head'; }
$render = !isset($render) || (string)$render !== '0';
$ttl = isset($ttl) ? (int)$ttl : 1200;

$assetsBase = rtrim($modx->getOption('assets_url', null, MODX_ASSETS_URL), '/').'/components/scxcaptchaajaxform/';
$css = <<<CSS
.scx-hp{ position:absolute!important;left:-9999px;top:auto;width:1px;height:1px;overflow:hidden;}
.scx-captcha{ display:flex;gap:.5rem;align-items:center;flex-wrap:wrap;margin:.4rem 0}
.scx-img{ border-radius:8px;box-shadow:0 1px 4px rgba(0,0,0,.08);background:#eef2ff}
.scx-refresh{ border:0;background:#eef2ff;padding:.45rem .6rem;border-radius:8px;cursor:pointer;color:#000;}
.scx-refresh:hover{ background:#e2e8ff}
.scx-input{ padding:.55rem .7rem;border:1px solid #e2e8f0;border-radius:8px}
.scx-error{ color:#d00;font-size:.9em;margin-top:.25rem}
CSS;

$placeholderGif = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==';
$js = <<<JS
"use strict";
(function(){
  const scxAssets = "{$assetsBase}";
  const placeholder = "{$placeholderGif}";

  function load(wrap){
    const token = (wrap.querySelector('input[name="scx_token"]') || { }).value || wrap.getAttribute("data-scx-token") || "";
    if(!token) return;
    const url = scxAssets + "captcha.php?t=" + encodeURIComponent(token) + "&v=" + Date.now();
    const img = wrap.querySelector(".scx-img");
    const btn = wrap.querySelector(".scx-refresh");
    if(btn) btn.disabled = true;
    if(img){
      img.src = url;
      img.addEventListener("load", function(){ if(btn) btn.disabled = false; }, { once:true });
      img.addEventListener("error", function(){ if(btn) btn.disabled = false; }, { once:true });
    }
  }

  function resetWrap(wrap){
    if(!wrap) return;
    const code = wrap.querySelector('input[name="scx_code"]');
    if (code) code.value = "";
    const img = wrap.querySelector(".scx-img");
    if (img) img.src = placeholder; // на всякий случай
    load(wrap);
  }

  function wrapByForm(form){
    return form ? form.querySelector(".scx-captcha") : null;
  }

  function init(wrap){
    if(!wrap || wrap.dataset.inited === "1") return;
    wrap.dataset.inited = "1";
    const img = wrap.querySelector(".scx-img");
    const btn = wrap.querySelector(".scx-refresh");
    const ts  = wrap.querySelector('input[name="scx_ts"]');
    if(img && !img.getAttribute("src")) img.src = placeholder;
    if(ts && !ts.value) ts.value = Date.now();
    if(btn) btn.addEventListener("click", function(){ load(wrap); }, { passive:true });
    if(img) img.addEventListener("click", function(){ load(wrap); }, { passive:true });
    const code = wrap.querySelector('input[name="scx_code"]');
    if(code) code.addEventListener("focus", function(){ if(img && img.src === placeholder) load(wrap); }, { once:true });
  }

  function clearFieldError(form, name){
    const el = form && form.querySelector('[name="'+name+'"]');
    if (!el) return;
    let cont = el.closest('.scx-field') || el.parentElement;
    if (!cont) cont = el.parentElement;
    const err = cont && cont.querySelector('.scx-error');
    if (err) err.remove();
    el.classList.remove('has-error');
  }

  function setFieldError(form, name, html){
    const el = form && form.querySelector('[name="'+name+'"]');
    if (!el) return;
    let cont = el.closest('.scx-field') || el.parentElement;
    if (!cont) cont = el.parentElement;
    clearFieldError(form, name);
    const span = document.createElement('div');
    span.className = 'scx-error';
    span.innerHTML = html;
    // если под полем есть контейнер, вставим после инпута
    if (el.nextSibling) el.parentNode.insertBefore(span, el.nextSibling);
    else el.parentNode.appendChild(span);
    el.classList.add('has-error');
  }

  function initAll(){ document.querySelectorAll(".scx-captcha").forEach(init); }

  // первичная инициализация
  if(document.readyState === "loading"){
    document.addEventListener("DOMContentLoaded", initAll, { once:true });
  } else {
    initAll();
  }

  // авто-инициализация для динамики
  if("MutationObserver" in window){
    new MutationObserver(function(muts){
      muts.forEach(function(m){
        (m.addedNodes || []).forEach(function(n){
          if(n.nodeType !== 1) return;
          if(n.matches && n.matches(".scx-captcha")) init(n);
          if(n.querySelectorAll) n.querySelectorAll(".scx-captcha").forEach(init);
        });
      });
    }).observe(document.documentElement, { childList:true, subtree:true });
  }

  // ==== АДАПТЕР ДЛЯ FetchIt ====

  // Success: очистить ошибку и перерисовать капчу
  document.addEventListener("fetchit:success", function(e){
    const form = e.target;
    clearFieldError(form, 'scx_code');
    const wrap = wrapByForm(form);
    if (wrap) resetWrap(wrap);
  });

  // Error: если есть ошибка scx_code — показать её и перерисовать капчу
  document.addEventListener("fetchit:error", function(e){
    const form = e.target;
    try{
      const d = e.detail || { };
      // поддерживаем разные форматы: errors.*, result.errors, response.errors, data.*
      const payload = d.response || d.result || d || { };
      const errors = payload.errors || payload.data || { };
      const errHtml = errors && (errors.scx_code || errors['scx_code[]']);
      if (errHtml) {
        setFieldError(form, 'scx_code', errHtml);
        const wrap = wrapByForm(form);
        if (wrap) resetWrap(wrap);
      }
    }catch(_){ }
  });

  // Reset: убрать ошибку и перерисовать капчу
  document.addEventListener("fetchit:reset", function(e){
    const form = e.target;
    clearFieldError(form, 'scx_code');
    const wrap = wrapByForm(form);
    if (wrap) resetWrap(wrap);
  });

  // Экспорт
  window.ScxCaptcha = {
    initAll: initAll,
    reloadInForm: function(form){
      const wrap = wrapByForm(form);
      if (wrap) resetWrap(wrap);
    }
  };
})();
JS;




/* === ассеты === */
$out = '';
if ($includeAssets === 'head') {
    if (!$modx->getPlaceholder('scx_css_loaded')) {
        $modx->regClientStartupHTMLBlock("<style>{$css}</style>");
        $modx->setPlaceholder('scx_css_loaded', 1);
    }
    if (!$modx->getPlaceholder('scx_js_loaded')) {
        $modx->regClientStartupScript("<script>{$js}</script>");
        $modx->setPlaceholder('scx_js_loaded', 1);
    }
} elseif ($includeAssets === 'inline') {
    $out .= "<style>{$css}</style><script>{$js}</script>";
}

/* если нужна только регистрация ассетов — выходим */
if (!$render) {
    return $out;
}

/* === генерация токена (сессию НЕ закрываем) === */
$now = time();
if (!isset($_SESSION['scx_allowed']) || !is_array($_SESSION['scx_allowed'])) {
    $_SESSION['scx_allowed'] = [];
} else {
    foreach ($_SESSION['scx_allowed'] as $k => $ts) {
        if (!is_int($ts) || ($now - (int)$ts) > $ttl) unset($_SESSION['scx_allowed'][$k]);
    }
    if (count($_SESSION['scx_allowed']) > 200) {
        $keys = array_slice(array_keys($_SESSION['scx_allowed']), -200);
        $_SESSION['scx_allowed'] = array_intersect_key($_SESSION['scx_allowed'], array_flip($keys));
    }
}
$token = bin2hex(random_bytes(8));
$_SESSION['scx_allowed'][$token] = $now;

/* === разметка === */
$html = <<<HTML
<div class="scx-captcha" data-scx-token="{$token}">
  <label class="scx-hp">Оставьте пустым
    <input type="text" name="scx_hp" autocomplete="off" tabindex="-1">
  </label>

  <input type="hidden" name="scx_ts" value="">
  <img class="scx-img" src="" alt="Нажмите «Обновить», чтобы получить картинку" width="140" height="48">
  <button class="scx-refresh" type="button">Обновить</button>

  <input class="scx-input" type="text" name="scx_code" inputmode="numeric"
         pattern="[0-9][0-9][0-9][0-9][0-9]" autocomplete="off" placeholder="Число с картинки" required>
  <input type="hidden" name="scx_token" value="{$token}">
</div>
HTML;

return $out . $html;
